<?php
/****************************************
 * XKLog 安装文件
 *
 * 更新：2009-5-28
 * 版本：V1.0
 ****************************************/

error_reporting(7);
set_magic_quotes_runtime(0);
define('IN_XKLOG',true);
define('XKLOG_ROOT',str_replace('\\','/',substr(dirname(__FILE__),0,-7)));
header('Content-Type: text/html; charset=utf-8');

if ( get_magic_quotes_gpc() ) {
	strip_slashes($_GET);
	strip_slashes($_POST);
}

if ( !ini_get('register_globals') ) {
	@extract($_POST, EXTR_SKIP);
	@extract($_GET, EXTR_SKIP);
}

if (!function_exists('file_put_contents')) {
	function file_put_contents($file, $data, $append = false) {
		$mode = $append ? 'ab' : 'wb';
		$fp = @fopen($file,$mode) or die("can not open file $file !");
		flock($fp, LOCK_EX);
		$len = fwrite($fp, $data);
		flock($fp, LOCK_UN);
		@fclose($fp);
		return $len;
	}
}

function strip_slashes(&$array) {
	return is_array($array) ? array_map("strip_slashes", $array) : stripslashes($array);
}

function result($result = 1, $output = 1) {
	if($result) {
		$text = ' ... <span style="color:blue">OK</span><br />';
		if(!$output) {
			return $text;
		}
		echo $text;
	} else {
		$text = ' ... <span style="color:red">Failed</span><br />';
		if(!$output) {
			return $text;
		}
		echo $text;
	}
}

function writeable($var) {
	$result = false;
	if ( !is_dir($var) ) {
		@mkdir($var, 0777);
	}
	if ( is_dir($var) ) {
		$var .= 'temp.txt';
		if ( ($fp=@fopen($var, 'wb')) && (@fwrite($fp, 'XKLog')) ) {
			@fclose($fp);
			@unlink($var);
			$result = true;
		}
	}
	return $result;
}

function createtable($sql) {
	$type = strtoupper(preg_replace("/^\s*CREATE TABLE\s+.+\s+\(.+?\).*(ENGINE|TYPE)\s*=\s*([a-z]+?).*$/isU", "\\2", $sql));
	$type = in_array($type, array('MYISAM', 'HEAP')) ? $type : 'MYISAM';
	return preg_replace("/^\s*(CREATE TABLE\s+.+\s+\(.+?\)).*$/isU", "\\1", $sql).
		(mysql_get_server_info() > '4.1' ? " ENGINE=$type DEFAULT CHARSET=".str_replace('-','','UTF-8') : " TYPE=$type");
}

$confile = XKLOG_ROOT . './include/config.php';
$lockfile = XKLOG_ROOT . './cache/install.lock';

require( XKLOG_ROOT.'./function/fun_global.php' );
require( XKLOG_ROOT.'./function/fun_show.php' );

$step = isset($step) ? intval($_GET['step']) : 0;

// 检查博客是否安装过
if ( file_exists($lockfile) ) {
	echo_error( '<li>XKLog 似乎已经安装过了，请勿重复安装。</li><li>如果您确实需要重装 XKLog，请先删除 cache 文件夹下的 install.lock 文件，再运行安装程序。</li>' );
}

obstart();

switch( $step )
{
    case 1:
        echo_step_1();
    	break;
    case 2:
        echo_step_2();
    	break;
    case 3:
        echo_step_3();
    	break;
       case 4:
        echo_step_4();
    	break;
    default:
        echo_main();
}


function echo_main(){
	echo_head('欢迎来到 XKLog 世界！');
?>
<body>
<h1 id="logo" style="text-align: center">XKLog V0.7 安装程序</h1>
<p style="text-align: center">XKLog! 开源个人博客系统!</p>

<h1>作者的话</h1>
<ul>
	<li>如果你觉得这个界面有点眼熟，请不要惊讶，因为这个文件是从 WordPress 抄来的 O(∩_∩)O  我偷一下懒啦~ ~ ~</li>
	<li>您需要花一分钟时间进行博客安装。安装过程不能中断，请确认您现在处于无所事事的状态~ ~</li>
	<li>如果你对 XKLog 有任何建议、想法、评论或发现 Bug，请加入<a href="http://bbs.xklab.cn/">支持论坛</a>。</li>
</ul>

<h1>版权许可</h1>
<p>XKLog 基于 <abbr title="GNU Public License">GPL</abbr> 通用许可协议发布。见(英文) <a href="license.txt">license.txt</a>。</p>

<form action="install.php?step=1" method="post">
	<center><input type="submit" name="Submit" class="button" value="开始安装" /></center>
<form>
</body>
<?
}

function echo_step_1(){
	global $confile;
	echo_head( '第一步 环境检查' );
	$result = 0;
?>
<body>
<h1 class="step">第一步 环境检查</h1>
<form action="install.php?step=2" method="post">
	<table border="0">
		<tr>
			<td>
			服务器配置
			<p><?php
			echo '操作系统：'.PHP_OS.result(1,0);
			echo 'PHP版本：'.PHP_VERSION;
			if ( PHP_VERSION > 4 ) {
				result(1,1);
			} else {
				result(0,1);
				$result += 1;
			}
			echo 'MySQL数据库：';
			if ( function_exists('mysql_connect') ) {
				echo '支持'.result(1,0);
			} else {
				echo '不支持'.result(0,0);
				$result += 1;
			}
			echo 'GD库：';
			if ( function_exists('imagecreate') ) {
				echo '支持'.result(1,0);
			} else {
				echo '不支持'.result(0,0);
			}
			?></p>
			</td>
		</tr>
		<tr>
			<td></td>
		</tr>
		<tr>
			<td>
			目录和文件属性
			<p><?php
			$confilewriteable = './include/config.php';
			if (is_writable( $confile )) {
				$confilewriteable .= result(1,0);
			} else {
				$confilewriteable .= result(0,0);
				$result += 1;
				echo '<p style="color:red">发生错误，请更改文件属性为 777</p>';
			}
			echo $confilewriteable;
			$uploaddir = XKLOG_ROOT.'./upload/';
			$cachedir = XKLOG_ROOT.'./cache/';
			$pagedir = XKLOG_ROOT.'./article/';
			$datadir = XKLOG_ROOT.'./article/';
			if ( writeable($cachedir) ) {
				echo './cache/'.result(1,0);
			} else {
				echo './cache/'.result(0,0);
				$result += 1;
				echo '<p style="color:red">发生错误，请更改目录属性为 777</p>';
			}
			if ( writeable($uploaddir) ) {
				echo './upload/'.result(1,0);
			} else {
				echo './upload/'.result(0,0);
				$result += 1;
				echo '<p style="color:red">发生错误，请更改目录属性为 777</p>';
			}
			if ( writeable($pagedir) ) {
				echo './article/'.result(1,0);
			} else {
				echo './article/'.result(0,0);
				$result += 1;
				echo '<p style="color:red">发生错误，请更改目录属性为 777</p>';
			}
			if ( writeable($datadir) ) {
				echo './data/'.result(1,0);
			} else {
				echo './data/'.result(0,0);
				$result += 1;
				echo '<p style="color:red">发生错误，请更改目录属性为 777</p>';
			}
			?></p>
			</td>
		</tr>
	</table>
	<?php if( $result != 0 ){ echo '<p style="color:red">此空间暂时无法安装 XKLog</p>'; } ?>
	<center><input type="button" class="button" onclick="history.back();" value="上一步" /> <?php if( $result == 0 ){ echo '<input type="submit" name="Submit" class="button" value="下一步" />'; } ?></center>
<form>
</body>
<?php
}

function echo_step_2(){
	echo_head( '第二步 博客信息' );
	$blog_path = $_SERVER[ 'SCRIPT_NAME' ];
	$blog_path = str_replace( 'install/install.php', '', $blog_path);
?>
<body>
<h1 class="step">第二步 博客信息</h1>
<form action="install.php?step=3" method="post">
	<table border="0">
	<tr>
		<td align="right">域名信息：</td>
		<td><input name="BlogDomain" type="text" size="30" value="<?php echo 'http://' . $_SERVER['SERVER_NAME'] . '/'; ?>" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>要以 "http://" 开头，以 "/" 结束</p></td>
	</tr>
	<tr>
		<td align="right">安装路径：</td>
		<td><input name="BlogPath" type="text" size="30" value="<?php echo $blog_path; ?>" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>要以 "http://" 开头，以 "/" 结束</p></td>
	</tr>
	<tr>
		<td align="right">前缀字符：</td>
		<td><input name="PrefixStr" type="text" size="30" value="XKLog_" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>如果需要安装多个程序副本，您必须修改此项</p></td>
	</tr>
	<tr>
		<td align="right">MySQL服务器地址：</td>
		<td><input type="text" name="dbhost" size="30" value="localhost" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>一般为 localhost</p></td>
	</tr>
	<tr>
		<td align="right">数据库用户名：</td>
		<td><input name="dbuser" type="text" size="30" value="dbuser" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>如果您不知道此项填什么，请咨询您的空间提供商</p></td>
	</tr>
	<tr>
		<td align="right">数据库密码：</td>
		<td><input name="dbpass" type="text" size="30" value="dbpass" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>如果您不知道此项填什么，请咨询您的空间提供商</p></td>
	</tr>
	<tr>
		<td align="right">数据库名称：</td>
		<td><input name="dbname" type="text" size="30" value="dbname" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>如果您不知道此项填什么，请咨询您的空间提供商</p></td>
	</tr>
	<tr>
		<td align="right">博客名称：</td>
		<td><input name="BlogName" type="text" size="30" value="我的部落格" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的博客名称。不用担心，您以后仍然可以修改此项设置 ^_^</p></td>
	</tr>
	<tr>
		<td align="right">博客描述：</td>
		<td><input name="BlogDescription" type="text" size="30" value="不要把光阴埋葬，乘着风追，落到有永恒的地方" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的博客描述。同样地，您以后仍然可以修改此项设置。</p></td>
	</tr>
	<tr>
		<td align="right">管理员名称：</td>
		<td><input name="AdminName" type="text" size="30" value="admin" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的大名。想好了，以后可不能改了 ^_^</p></td>
	</tr>
	<tr>
		<td align="right">前台密码：</td>
		<td><input name="PassWord" type="text" size="30" value="admin" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的前台密码。最好八位以上，包含字母、数字和符号，但是不要复杂到自己都忘记了o(╯□╰)o</p></td>
	</tr>
	<tr>
		<td align="right">后台密码：</td>
		<td><input name="SuperPassWord" type="text" size="30" value="admin888" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的后台密码。必须和前台密码不相同。</p></td>
	</tr>
	</table>

	<center><input type="button" class="button" onclick="history.back();" value="上一步" /> <input type="submit" name="Submit" class="button" value="下一步" /></center>
<form>
</body>
<?php
}

function echo_step_3(){
	global $lockfile,$confile;
	$domian = trim( $_POST[ 'BlogDomain' ] );
	$blogname = trim( $_POST[ 'BlogName' ] );
	$blogpath = trim( $_POST[ 'BlogPath' ] );
	$blogdescription = trim( $_POST[ 'BlogDescription' ] );
	$admin = trim( $_POST[ 'AdminName' ] );
	$dbhost = trim( $_POST[ 'dbhost' ] );
	$dbuser = trim( $_POST[ 'dbuser' ] );
	$dbpass = trim( $_POST[ 'dbpass' ] );
	$dbname = trim( $_POST[ 'dbname' ] );
	$prefix = trim( $_POST[ 'PrefixStr' ] );
	$password = trim( $_POST[ 'PassWord' ] );
	$superpassword = trim( $_POST[ 'SuperPassWord' ] );
	if ( $domian == '' ){
		echo_error( '<li>您没有输入<b>域名信息</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $blogpath == '' ){
		echo_error( '<li>您没有输入<b>安装路径</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $prefix == '' ){
		echo_error( '<li>您没有输入<b>前缀字符</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $dbhost == '' ){
		echo_error( '<li>您没有输入<b>MySQL服务器地址</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $dbuser == '' ){
		echo_error( '<li>您没有输入<b>数据库用户名</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $dbpass == '' ){
		echo_error( '<li>您没有输入<b>数据库密码</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $dbname == '' ){
		echo_error( '<li>您没有输入<b>数据库名称</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $blogname == '' ){
		echo_error( '<li>您没有输入<b>博客名称</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $blogdescription == '' ){
		echo_error( '<li>您没有输入<b>博客描述</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $admin == '' ){
		echo_error( '<li>您没有输入<b>管理员名称</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $password == '' ){
		echo_error( '<li>您没有输入<b>前台密码</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $superpassword == '' ){
		echo_error( '<li>您没有输入<b>后台密码</b>。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	if ( $superpassword == $password ){
		echo_error( '<li>您输入的<b>前台密码</b>与<b>后台密码</b>相同。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	}
	$chars = array("\\",'&',' ',"'",'"','/','*',',','<','>',"\r","\t","\n",'#','$','(',')','%','@','+','?',';','^');
	foreach($chars as $value){
		if (strpos($admin,$value) != false){
			echo_error( '<li>您输入的<b>管理员名称</b>不合法。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
		}
	}
	if ( !$link = @mysql_connect( $dbhost,$dbuser,$dbpass ) ) {
		echo_error( '<li>数据库连接失败，请检查配置信息是否正确！</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
	} else {
		if ( !@mysql_select_db( $dbname, $link) ) {
			if ( !@mysql_query("CREATE DATABASE [$dbname]", $link) ) {
				echo_error( '<li>数据库 <b>' . $dbname . '</b> 不存在，系统也无法创建。</li><li>点击 <a href="#" onclick="javascript:history.back()">这里</a> 返回。</li>' );
			}
		}
	}
	echo_head( '正在安装……' );
?>
<body>
<h1 class="step">正在安装……</h1>
<ul>
	<li>正在为您安装 XKLog V1.0 Beta，请稍候……</li>
	<li>安装期间请勿刷新或关闭页面。</li>
<?php
	flush();
    ob_flush();

	// 修改配置文件
	$fp = fopen($confile, 'rb');
	$content = fread($fp, filesize($confile));
	fclose($fp);
	$content = str_replace("localhost", $dbhost, $content);
	$content = str_replace("{*DB_USER*}", $dbuser, $content);
	$content = str_replace("{*DB_PWD*}", $dbpass, $content);
	$content = str_replace("{*DB_NAME*}", $dbname, $content);
	$content = str_replace("{*PREFIX_STR*}", $prefix, $content);
	$content = str_replace("{*BLOG_PATH*}", $blogpath, $content);
	$content = str_replace("{*SUPER_PASSWORD*}", strtoupper( md5( $prefix . $superpassword ) ), $content);
	file_put_contents($confile, $content);

	// 建立数据表
	include( '../function/class_mysql.php');
	$db = new mysql();
	$db->connect($dbhost, $dbuser, $dbpass, $dbname, false);

	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Set`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Article`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Guestbook`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Comment`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "User`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "SafeLog`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Menu`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Link`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Category`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Plugin`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Upload`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Trackback`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Tags`" );
	$db->query( "DROP TABLE IF EXISTS `" . $prefix . "Online`" );

	$db->query( "CREATE TABLE `" . $prefix . "Set` (		`BlogName` varchar(50) NOT NULL,
															`Description` varchar(255) NOT NULL,
															`KeyWords` varchar(255),
															`BeiAn` varchar(50),
															`Domain` varchar(100) NOT NULL,
															`BuildDate` varchar(50) NOT NULL,
															`VisitNum` int default 1 NOT NULL,
															`TodayNum` int default 1 NOT NULL,
															`MaxPerPage` int default 8 NOT NULL,
															`MaxOnline` int default 100 NOT NULL,
															`FilterWords` text,
															`NameFilter` text,
															`Enable` tinyint(1) default 1 NOT NULL,
															`CloseReason` varchar(255),
															`RegEnable` tinyint(1) default 1 NOT NULL,
															`Comment` int default 0 NOT NULL,
															`ComNum` int default 0 NOT NULL,
															`ComTimer` int default 0 NOT NULL,
															`ComMaxLength` int default 600 NOT NULL,
															`ArtMaxLength` int default 30000 NOT NULL,
															`ArtType` varchar(50) NOT NULL,
															`ShowType` int default 0 NOT NULL,
															`Verify` int default 1 NOT NULL,
															`Style` varchar(255) default 'Default' NOT NULL ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Article` (	`ID` int unsigned NOT NULL auto_increment,
															`Title` varchar(255) NOT NULL,
															`KeyWords` varchar(255) default '' NOT NULL,
															`Description` varchar(255) default '' NOT NULL,
															`Time` varchar(50) NOT NULL,
															`Author` varchar(50) NOT NULL,
															`Category` int NOT NULL,
															`Tag` varchar(255),
															`IsTop` tinyint(1) NOT NULL default 0,
															`IsDel` tinyint(1) NOT NULL default 0,
															`Summary` text NOT NULL,
															`Content` text NOT NULL,
															`Read` int default 0 NOT NULL,
															`Comment` int default 0 NOT NULL,
															`Trackback` int default 0 NOT NULL,
															`Type` varchar(10) NOT NULL,
															`Address` varchar(255) default '',
															`Update` tinyint(1) NOT NULL default 0,
															PRIMARY KEY (ID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Comment` (	`CID` int unsigned NOT NULL auto_increment,
															`ArticleID` int default 1 NOT NULL,
															`IsDel` tinyint(1) NOT NULL default 0,
															`Author` varchar(50) NOT NULL,
															`Email` varchar(255) default '' NOT NULL,
															`Index` varchar(255) default '' NOT NULL,
															`Time` varchar(50) NOT NULL,
															`Comment` text NOT NULL,
															`ReplyUser` varchar(50) default '',
															`Reply` text,
															`ReplyTime` varchar(50) default '',
															`IsShow` tinyint(1) NOT NULL default 1,
															PRIMARY KEY (CID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "User` (		`UID` int unsigned NOT NULL auto_increment,
															`UserName` varchar(50) NOT NULL,
															`PassWord` varchar(50) NOT NULL,
															`Group` int default 0 NOT NULL,
															`IsDel` tinyint(1) NOT NULL default 0,
															`Email` varchar(255),
															`QQNum` int,
															`Index` varchar(255),
															`IP` varchar(50),
															`Time` varchar(50),
															PRIMARY KEY (UID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Link` (		`LID` int unsigned NOT NULL auto_increment,
															`IsDel` tinyint(1) NOT NULL default 0,
															`Title` varchar(255) NOT NULL,
															`Description` varchar(255),
															`Address` varchar(255) NOT NULL,
															PRIMARY KEY (LID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "SafeLog` (	`SID` int unsigned NOT NULL auto_increment,
															`Description` varchar(255),
															`Time` varchar(50) NOT NULL,
															`IP` varchar(50) NOT NULL,
															PRIMARY KEY (SID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Menu` (		`MID` int unsigned NOT NULL auto_increment,
															`Num` int NOT NULL,
															`Name` varchar(50) NOT NULL,
															`Title` varchar(50) NOT NULL,
															`Type` int NOT NULL,
															`Address` varchar(255) NOT NULL,
															PRIMARY KEY (MID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Category` (	`CID` int unsigned NOT NULL auto_increment,
															`Num` int NOT NULL,
															`Name` varchar(255) NOT NULL,
															`Alias` varchar(255) NOT NULL,
															`Description` varchar(255),
															`ArticleNum` int default 0 NOT NULL,
															PRIMARY KEY (CID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Online` (		`OID` int unsigned NOT NULL auto_increment,
															`IP` varchar(50) NOT NULL,
															`Time` varchar(255) NOT NULL,
															PRIMARY KEY (OID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Trackback`(	TB_ID int unsigned NOT NULL auto_increment,
															TB_Article_ID int NOT NULL,
															TB_Title varchar(255),
															TB_Excerpt varchar(255),
															TB_URL varchar(255) NOT NULL,
															TB_BlogName varchar(255),
															TB_Type tinyint(1) NOT NULL default 0,
															PRIMARY KEY (TB_ID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Tags`(		T_ID int unsigned NOT NULL auto_increment,
															T_Name varchar(255) NOT NULL,
															T_Num int NOT NULL,
															PRIMARY KEY (T_ID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);
	$db->query( "CREATE TABLE `" . $prefix . "Upload`(		UL_ID int unsigned NOT NULL auto_increment,
															UL_AID int NOT NULL,
															UL_FilePath varchar(255) NOT NULL,
															UL_Thumb varchar(255) default '' NOT NULL,
															UL_FileSize int NOT NULL,
															UL_Time int NOT NULL,
															UL_Downloads int default 0 NOT NULL,
															PRIMARY KEY (UL_ID) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
	);

	$db->query( "INSERT INTO `" . $prefix . "Set` (`BlogName`,`Description`,`Domain`,`BuildDate`,`CloseReason`,`FilterWords`,`NameFilter`,`ArtType`,`Style`) VALUES ('" . $blogname . "', '" . $blogdescription . "', '" . $domian . "', '" . time() . "', '博客维护中……', 'Fuck|http://', '游客|客人|Admin|Fuck|管理|Guest', '半静态', 'default')" );

	$db->query( "INSERT INTO `" . $prefix . "Article` (`Title`,`Time`,`Author`,`Category`,`Tag`,`Summary`,`Content`,`Read`,`Comment`,`Type`) VALUES ('欢迎使用 XKLog！', '" . time() . "', '" . $admin . "', 1, '1,2', '', '<p><strong>欢迎使用 XKLog！</strong><br /><br />这是安装程序自动写入的一篇日志，您可以编辑或删除。<br /><br />如果您有任何意见或建议，请访问<a href=http://www.xklab.cn>星空工作室</a>。</p>',1,1,'动态')" );

	$db->query( "INSERT INTO `" . $prefix . "Comment` (`ArticleID`,`Author`,`Time`,`Comment`,`ReplyUser`,`Reply`,`ReplyTime`) VALUES (0,'Guest','" . time() . "','这是安装程序自动写入的一条留言。','" . $admin . "','这是安装程序自动写入的一条管理员回复。', '" . time() . "')" );
	$db->query( "INSERT INTO `" . $prefix . "Comment` (`ArticleID`,`Author`,`Time`,`Comment`,`ReplyUser`,`Reply`,`ReplyTime`) VALUES (1,'Guest','" . time() . "','这是安装程序自动写入的一条评论。','" . $admin . "','这是安装程序自动写入的一条管理员回复。', '" . time() . "')" );

	$db->query( "INSERT INTO `" . $prefix . "User` (`UserName`,`PassWord`,`Group`) VALUES ('" . $admin . "','" . strtoupper( md5( $prefix . $password ) ) . "',8)" );

	$db->query( "INSERT INTO `" . $prefix . "Link` (`Title`,`Description`,`Address`) VALUES ('星空工作室','XKLog 官方网站','http://www.xklab.cn/')" );

	$db->query( "INSERT INTO `" . $prefix . "Category` (`Num`,`Name`,`Alias`,`Description`,`ArticleNum`) VALUES (1,'默认分类','default','系统默认分类',1)" );

	$db->query( "INSERT INTO `" . $prefix . "Menu` (`Num`,`Name`,`Title`,`Type`,`Address`) VALUES (1,'Index','首页',0,'index.php')" );
	$db->query( "INSERT INTO `" . $prefix . "Menu` (`Num`,`Name`,`Title`,`Type`,`Address`) VALUES (2,'Guestbook','留言本',0,'guestbook.php')" );
	$db->query( "INSERT INTO `" . $prefix . "Menu` (`Num`,`Name`,`Title`,`Type`,`Address`) VALUES (3,'Tags','标签云',0,'tags.php')" );

	$db->query( "INSERT INTO `" . $prefix . "Tags` (`T_Name`,`T_Num`) VALUES ('XKLog',1)" );
	$db->query( "INSERT INTO `" . $prefix . "Tags` (`T_Name`,`T_Num`) VALUES ('欢迎',1)" );

	@fopen($lockfile,'wb');
?>
</ul>
<h1 class="step">安装完成</h1>
<ul>
	<li>恭喜你，XKLog 已经安装完毕！Just enjoy it！</li>
	<li>点击 <a href="../index.php">这里</a> 前往首页。</li>
</ul>
</body>
<?php
}
?>
</html>
<?php

function echo_error( $message ){
	echo_head( '出错了！' )
?>
<body>
<h1 class="step">出错了！</h1>
<ul><?php echo( $message ) ?><br /><li>还有疑问，请访问 <a href="http://bbs.xklab.cn/" target="_blank">支持论坛</a> 寻求帮助。</li></ul>
</body>
</html>
<?php
	exit;
}

function echo_head( $str ){
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title>XKLog - 安装程序 - <?php echo( $str ) ?></title>
	<style>
	html { background: #f7f7f7; }
	body {background: #fff;color: #333;font-family: "Lucida Grande", Verdana, Arial, "Bitstream Vera Sans", sans-serif;margin: 2em auto 0 auto;width: 700px;padding: 1em 2em;-moz-border-radius: 11px;-khtml-border-radius: 11px;-webkit-border-radius: 11px;border-radius: 11px;border: 1px solid #dfdfdf;}
	a { color: #2583ad; text-decoration: none; }
	a:hover { color: #d54e21; }
	h1 {border-bottom: 1px solid #dadada;clear: both;color: #666;font: 24px Georgia, "Times New Roman", Times, serif;margin: 5px 0 0 -4px;padding: 0;padding-bottom: 7px;}
	h2 { font-size: 16px; }
	p, li {padding-bottom: 2px;font-size: 12px;line-height: 18px;}
	code { font-size: 13px; }
	ul, ol { padding: 5px; }
	#logo { margin: 6px 0 14px 0; border-bottom: none;}
	.step {margin: 20px 0 15px;}
	.step, th { text-align: left; padding: 0; }
	.submit input, .button, .button-secondary {font-family: "Lucida Grande", Verdana, Arial, "Bitstream Vera Sans", sans-serif;text-decoration: none;font-size: 14px !important;line-height: 16px;padding: 6px 12px;cursor: pointer;border: 1px solid #bbb;color: #464646;-moz-border-radius: 15px;-khtml-border-radius: 15px;-webkit-border-radius: 15px;border-radius: 15px;-moz-box-sizing: content-box;-webkit-box-sizing: content-box;-khtml-box-sizing: content-box;box-sizing: content-box;}
	.button:hover, .button-secondary:hover, .submit input:hover {color: #000;border-color: #666;}
	.button, .submit input, .button-secondary {background: #f2f2f2 url("white-grad.png") repeat-x scroll left top;}
	.button:active, .submit input:active, .button-secondary:active {background: #eee url("white-grad-active.png") repeat-x scroll left top;}
	</style>
</head>
<?php
}
?>